/*
 * $RCSfile: Report.h,v $
 * 
 * created by rieger on 03.04.2006
 * 
 * $Revision: 1.0 $
 * 
 * $Date: 03.04.2006 16:46:20 $
 * 
 * Copyright:
 * Werum Software & Systems AG
 * Wulf-Werum-Strasse 3, 
 * 21337 Lueneburg
 */
#ifndef _REPORT_H_
#define _REPORT_H_

// <summary>
// Liefert Informationen ber einen Fehler, der bei einer DALE-UV-Prfung
// festgestellt wurde.
// </summary>
// <remarks>
// Enthlt zustzlich Funktionen zum Schreiben der Fehlerinformationen im TXT-
// und XML-Format.
// </remarks>
class __declspec(dllexport) DaleUvError
{
public:
   // <summary>
   // Erstellt ein neues DaleUvError-Objekt ohne Informationen zum Fehler.
   // </summary>
   // <param name="number">Nummer des Fehlers in der Reihenfolge wie dieser angeschrieben worden ist</param>
   DaleUvError(int number);

   // <summary>
   // Lscht alle gespeicherten Informationen zum Fehler.
   // </summary>
   ~DaleUvError();

   // <summary>
   // Liefert die Nummer des Fehlers in der Reihenfolge wie dieser angeschrieben worden ist.
   // </summary>
   // <returns>Nummer des Fehlers in der Reihenfolge wie dieser angeschrieben worden ist</returns>
   int getNumber();

   // <summary>
   // Setzt die Fehler-ID.
   // </summary>
   // <param name="id">Fehler-ID</param>
   void setId(const char* id);

   // <summary>
   // Liefert die Fehler-ID.
   // </summary>
   // <returns>Fehler-ID</returns>
   const char* getId();

   // <summary>
   // Setzt den Feldnamen des betroffenen Feldes.
   // </summary>
   // <param name="fieldName">Feldnamen des betroffenen Feldes</param>
   void setFieldName(const char* fieldName);

   // <summary>
   // Liefert den Feldnamen des betroffenen Feldes.
   // </summary>
   // <returns>Feldnamen des betroffenen Feldes</returns>
   const char* getFieldName();

   // <summary>
   // Setzt den Feldanzeigenamen des betroffenen Feldes.
   // </summary>
   // <param name="fieldDisplayName">Feldanzeigenamen des betroffenen Feldes</param>
   void setFieldDisplayName(const char* fieldDisplayName);

   // <summary>
   // Liefert den Feldanzeigenamen des betroffenen Feldes.
   // </summary>
   // <returns>Feldanzeigenamen des betroffenen Feldes</returns>
   const char* getFieldDisplayName();

   // <summary>
   // Setzt den Strukturname des betroffenen Feldes.
   // </summary>
   // <param name="referenceStructure">Strukturname des betroffenen Feldes</param>
   void setReferenceStructure(const char* referenceStructure);

   // <summary>
   // Liefert den Strukturname des betroffenen Feldes.
   // </summary>
   // <returns>Strukturname des betroffenen Feldes</returns>
   const char* getReferenceStructure();

   // <summary>
   // Setzt den Fehlergewicht (1 bis 9).
   // </summary>
   // <param name="weight">Fehlergewicht (1 bis 9)</param>
   void setWeight(int weight);

   // <summary>
   // Liefert den Fehlergewicht (1 bis 9).
   // </summary>
   // <returns>Fehlergewicht (1 bis 9)</returns>
   int getWeight();

   // <summary>
   // Setzt die Fehlerstufe (1 bis 3).
   // </summary>
   // <param name="level">Fehlerstufe (1 bis 3)</param>
   void setLevel(int level);

   // <summary>
   // Liefert die Fehlerstufe (1 bis 3).
   // </summary>
   // <returns>Fehlerstufe (1 bis 3)</returns>
   int getLevel();

   // <summary>
   // Setzt den Fehlercode.
   // </summary>
   // <param name="code">Fehlercode</param>
   void setCode(const char* code);

   // <summary>
   // Liefert den Fehlercode.
   // </summary>
   // <returns>Fehlercode</returns>
   const char* getCode();

   // <summary>
   // Setzt die Information, ob es sich um einen kritischen Fehler handelt.
   // </summary>
   // <param name="critical">Information, ob es sich um einen kritischen Fehler handelt</param>
   void setCritical(bool critical);

   // <summary>
   // Liefert die Information, ob es sich um einen kritischen Fehler handelt.
   // </summary>
   // <returns>Information, ob es sich um einen kritischen Fehler handelt</returns>
   bool isCritical();

   // <summary>
   // Setzt die Kurzbeschreibung des Fehlers.
   // </summary>
   // <param name="textShort">Kurzbeschreibung des Fehlers</param>
   void setTextShort(const char* textShort);

   // <summary>
   // Liefert die Kurzbeschreibung des Fehlers.
   // </summary>
   // <returns>Kurzbeschreibung des Fehlers</returns>
   const char* getTextShort();

private:
   int number;
   char* id;
   char* fieldName;
   char* fieldDisplayName;
   char* referenceStructure;
   int weight;
   int level;
   bool critical;
   char* code;
   char* textShort;
};

// <summary>
// Enthlt Eingabeparameter fr die Ausfhrung einer DALE-UV-Prfung und liefert
// Informationen ber die angeschriebenen Fehler zurck.
// </summary>
// <remarks>
// Enthlt zustzlich Funktionen zum Schreiben der Fehlerinformationen im TXT-
// und XML-Format.
// </remarks>
class __declspec(dllexport) DaleUvReport
{
public:
   // <summary>
   // Erstellt ein neues DaleUvReport-Objekt ohne Eingabeparameter.
   // </summary>
   DaleUvReport();

   // <summary>
   // Lscht alle gespeicherten Informationen zu den Fehlern.
   // </summary>
   ~DaleUvReport();

   // <summary>
   // Setzt den Dateinamen fr die Protokollausgabe.
   // </summary>
   // <param name="logFile">Dateiname fr die Protokollausgabe</param>
   void setLogFile(const char* logFile);

   // <summary>
   // Liefert den Dateinamen fr die Protokollausgabe.
   // </summary>
   // <returns>Dateiname fr die Protokollausgabe</returns>
   const char* getLogFile();

   // <summary>
   // Setzt den Log-Level fr die Protokollausgabe (0 bis 6).
   // </summary>
   // <param name="logLevel">Log-Level fr die Protokollausgabe (0 bis 6)</param>
   // <remarks>
   // Der Log-Level wird wie folgt interpretiert:
   // <p>
   // 0 - Keine Ausgaben<br/>
   // 1 - Schwere Fehler<br/>
   // 2 - Fehler<br/>
   // 3 - Warnungen<br/>
   // 4 - Informationen<br/>
   // 5 - Trace-Ausgaben<br/>
   // 6 - Debug-Ausgaben
   // </remarks>
   void setLogLevel(int logLevel);

   // <summary>
   // Liefert den Log-Level fr die Protokollausgabe (0 bis 6).
   // </summary>
   // <returns">Log-Level fr die Protokollausgabe (0 bis 6)</returns>
   // <remarks>
   // Der Log-Level wird wie folgt interpretiert:
   // <p>
   // 0 - Keine Ausgaben<br/>
   // 1 - Schwere Fehler<br/>
   // 2 - Fehler<br/>
   // 3 - Warnungen<br/>
   // 4 - Informationen<br/>
   // 5 - Trace-Ausgaben<br/>
   // 6 - Debug-Ausgaben
   // </remarks>
   int getLogLevel();

   // <summary>
   // Setzt den Dateinamen der zu prfenden XML-Datei.
   // </summary>
   // <param name="dataSource">Dateiname der zu prfenden XML-Datei</param>
   void setDataSource(const char* dataSource);

   // <summary>
   // Liefert den Dateinamen der zu prfenden XML-Datei.
   // </summary>
   // <returns>Dateiname der zu prfenden XML-Datei</returns>
   const char* getDataSource();

   // <summary>
   // Setzt den Namen der zu prfenden Nachricht.
   // </summary>
   // <param name="plausiName">Name der zu prfenden Nachricht</param>
   // <remarks>
   // Bei Dateiprfungen wird der Name aus der zu prfenden XML-Datei automatisch
   // ermittelt. Diese Angabe ist nur bei Feldprfungen notwendig.
   // </remarks>
   void setPlausiName(const char* plausiName);

   // <summary>
   // Liefert den Namen der zu prfenden Nachricht.
   // </summary>
   // <returns>Name der zu prfenden Nachricht</returns>
   const char* getPlausiName();

   // <summary>
   // Setzt die Plausi-Version im Format JJ_Q_VV.
   // </summary>
   // <param name="plausiVersion">Plausi-Version im Format JJ_Q_VV</param>
   // <remarks>
   // Die Version der Plausi wird automatisch aus der DLL-Datei ermittelt.
   // Diese Angabe ist nur im Serverbetrieb relevant, wenn verschiedene
   // Versionen parallel geladen und verwendet werden.
   // </remarks>
   void setPlausiVersion(const char* plausiVersion);

   // <summary>
   // Liefert die Plausi-Version im Format JJ_Q_VV.
   // </summary>
   // <returns>Plausi-Version im Format JJ_Q_VV</returns>
   const char* getPlausiVersion();

   // <summary>
   // Setzt den Prfschlssel fr die geprfte Eingabedatei.
   // </summary>
   // <param name="checkKey">30-stelliger Prfschlssel oder "1"</param>
   // <remarks>
   // Der 30-stelliger Prfschlssel wird nur vergeben, wenn die Eingabedatei
   // fehlerfrei ist, ansonsten wird dieser auf "1" gesetzt.
   // </remarks>
   void setCheckKey(const char* checkKey);

   // <summary>
   // Liefert den Prfschlssel fr die geprfte Eingabedatei.
   // </summary>
   // <returns>30-stelliger Prfschlssel oder "1"</returns>
   // <remarks>
   // Der 30-stelliger Prfschlssel wird nur vergeben, wenn die Eingabedatei
   // fehlerfrei ist, ansonsten wird "1" zurckgeliefert.
   // </remarks>
   const char* getCheckKey();

   // <summary>
   // Liefert die Information, ob es sich um die alte Version der Prfungen handelt.
   // </summary>
   // <returns>Information, ob es sich um die alte Version der Prfungen handelt</returns>
   bool isPriorVersion();

   // <summary>
   // Setzt den Namen des Feldes, welches geprft werden soll, im XPath-Format.
   // </summary>
   // <param name="field">Name des Feldes, welches geprft werden soll, im XPath-Format</param>
   // <remarks>
   // Der Name des Felds wird im XPath-Format angegeben mit der fr den
   // angegebenen Nachrichtentyp (Plausi-Name) gltigen Struktur, z.B.: /mahb_file/mahb/kdi/kdi_17
   // </remarks>
   void setField(const char* field);

   // <summary>
   // Liefert den Namen des Feldes, welches geprft werden soll, im XPath-Format.
   // </summary>
   // <returns>Name des Feldes, welches geprft werden soll, im XPath-Format</returns>
   const char* getField();

   // <summary>
   // Setzt den Wert des Feldes, welches geprft werden soll.
   // </summary>
   // <param name="value">Wert des Feldes, welches geprft werden soll</param>
   // <remarks>
   // Falls kein Wert angegeben wurde, kann diese Angabe weggelassen werden.
   // In diesem Fall wird geprft, ob der Leerwert fr das angegebene Feld
   // erlaubt ist oder nicht.
   // </remarks>
   void setValue(const char* value);

   // <summary>
   // Liefert Wert des Feldes, welches geprft werden soll.
   // </summary>
   // <returns>Wert des Feldes, welches geprft werden soll</returns>
   const char* getValue();

   // <summary>
   // Notiert einen Fehler in den Eingabeparametern.
   // </summary>
   // <param name="message">Fehlermeldung</param>
   void noteParameterError(const char* message);

   // <summary>
   // Notiert einen Fehler in der XML-Datei.
   // </summary>
   // <param name="message">Fehlermeldung</param>
   void noteXmlError(const char* message);

   // <summary>
   // Notiert einen Fehler beim Laden der Plausi.
   // </summary>
   // <param name="message">Fehlermeldung</param>
   void notePlausiLoadError(const char* message);

   // <summary>
   // Notiert einen Programmfehler.
   // </summary>
   // <param name="message">Fehlermeldung</param>
   void noteException(const char* message);

   // <summary>
   // Notiert einen Fehler.
   // </summary>
   // <param name="error">Fehler</param>
   void noteError(DaleUvError* error);

   // <summary>
   // Liefert den Rckgabecode des Programms.
   // </summary>
   // <returns>Rckgabecode des Programms</returns>
   // <remarks>
   // Hier wird der Rckgabecode des Programms wie folgt ermittelt:
   // <list type="bullet">
   //  <item>
   //   <term>0</term>
   //   <description>Prfung erfolgreich durchgefhrt, keine Fehler festgestellt.</description>
   //  </item>
   //  <item>
   //   <term>1</term>
   //   <description>Prfung erfolgreich durchgefhrt, Fehler der Stufe 1 gefunden.</description>
   //  </item>
   //  <item>
   //   <term>2</term>
   //   <description>Prfung erfolgreich durchgefhrt, Fehler der Stufe 2 gefunden.</description>
   //  </item>
   //  <item>
   //   <term>3</term>
   //   <description>Prfung erfolgreich durchgefhrt, Fehler der Stufe 3 gefunden.</description>
   //  </item>
   //  <item>
   //   <term>-1</term>
   //   <description>Programm- oder Parameterfehler gefunden.</description>
   //  </item>
   // </list>
   // </remarks>
   int getReturnCode();

   // <summary>
   // Gibt an, ob die Prfung erfolgreich durchgefhrt und keine Fehler
   // festgestellt wurden.
   // </summary>
   // <returns><c>true</c>, wenn die Prfung erfolgreich durchgefhrt und keine
   // Fehler festgestellt wurden, ansonsten <c>false</c></returns>
   bool isOk();

   // <summary>
   // Liefert die Anzahl der festgestellten Fehler.
   // </summary>
   // <returns>Anzahl der festgestellten Fehler</returns>
   int getNumOfErrors();

   // <summary>
   // Liefert die Anzahl der festgestellten Fehler mit der angegebenen Stufe.
   // </summary>
   // <param name="level">Fehlerstufe</param>
   // <returns>Anzahl der festgestellten Fehler mit der angegebenen Stufe</returns>
   int getNumOfErrors(int level);

   // <summary>
   // Sortiert die Fehlerliste nach dem Feldnamen der Bezugsfelder.
   // </summary>
   // <remarks>
   // Fehlermeldungen ohne Bezugsfelder (z.B. Ausnahmefehler) werden an den
   // Anfang gestellt.
   // </remarks>
   void sortErrorsByFieldName();

   // <summary>
   // Sortiert die Fehlerliste nach der Fehlerstufe und dem Feldnamen der
   // Bezugsfelder.
   // </summary>
   // <remarks>
   // Fehlermeldungen ohne Bezugsfelder (z.B. Ausnahmefehler) werden bei der
   // entsprechenden Stufe an den Anfang gestellt.
   // </remarks>
   void sortErrorsByLevelAndFieldName();

   // <summary>
   // Liefert den Fehler mit dem angegebenen Index aus der Gesamtliste.
   // </summary>
   // <param name="i">Index des gesuchten Fehlers</param>
   // <returns>Fehler mit dem angegebenen Index aus der Gesamtliste</returns>
   DaleUvError* getError(int i);

   // <summary>
   // Schreibt die gespeicherten Informationen zu den Fehlern in den angegebenen
   // Stream im Textformat.
   // </summary>
   // <param name="out">Ausgabe-Stream</param>
   // <remarks>
   // Der Ausgabeformat entspricht der Formatierung  der Fehlerinformation
   // aus der Vorgngerversion.
   // </remarks>
   //void writeTxt(std::ostream& out);
   //bool writeTxt(const char* fileName);

   // <summary>
   // Schreibt die gespeicherten Informationen zu den Fehlern in den angegebenen
   // Stream im XML-Format.
   // </summary>
   // <param name="out">Ausgabe-Stream</param>
   //void writeXml(std::ostream& out);
   //bool writeXml(const char* fileName);

private:
   char* logFile;
   int logLevel;
   char* dataSource;
   char* plausiName;
   char* plausiVersion;
   char* checkKey;
   char* field;
   char* value;
   //std::vector<DaleUvError*> errors;
   DaleUvError** errors;
   int numOfErrors;
   int returnCode;
};

#endif